import requests
import time
import sys
from config import API_BASE_URL, get_headers

def check_status(job_id):
    print(f"Checking status for Job ID: {job_id}")
    
    url = f"{API_BASE_URL}/jobs/{job_id}"
    
    try:
        response = requests.get(url, headers=get_headers())
        
        if response.status_code == 200:
            job = response.json()
            status = job.get('status')
            progress = job.get('progress', 0)
            
            print(f"✅ Status: {status.upper()}")
            print(f"   Progress: {progress}%")
            
            if job.get('messages'):
                print(f"   Latest Message: {job['messages'][-1]}")
                
            return status
        elif response.status_code == 404:
            print("❌ Job not found.")
            return None
        else:
            print(f"❌ Error checking status: {response.status_code}")
            print(response.text)
            return None

    except Exception as e:
        print(f"❌ Connection error: {str(e)}")
        return None

if __name__ == "__main__":
    if len(sys.argv) > 1:
        job_id = sys.argv[1]
    else:
        job_id = input("Enter Job ID to check: ").strip()
    
    if job_id:
        check_status(job_id)
