import requests
import sys
import os
from config import API_BASE_URL, get_headers

def download_result(job_id, output_filename=None):
    print(f"Downloading result for Job ID: {job_id}")
    
    url = f"{API_BASE_URL}/jobs/{job_id}/result"
    
    try:
        # Stream the download to handle large files
        response = requests.get(url, headers=get_headers(), stream=True)
        
        if response.status_code == 200:
            if not output_filename:
                # Try to get filename from header or default
                cd = response.headers.get('content-disposition')
                if cd and 'filename=' in cd:
                    output_filename = cd.split('filename=')[1].strip('"')
                else:
                    output_filename = f"model_output_{job_id}.docx"
            
            # Save the file
            with open(output_filename, 'wb') as f:
                for chunk in response.iter_content(chunk_size=8192):
                    f.write(chunk)
            
            print(f"✅ File saved to: {os.path.abspath(output_filename)}")
            return True
            
        elif response.status_code == 404:
            print("❌ Job or result file not found.")
        elif response.status_code == 409:
             print("⚠️  Job is not yet complete. Please check status first.")
        else:
            print(f"❌ Error downloading: {response.status_code}")
            print(response.text)
            
        return False

    except Exception as e:
        print(f"❌ Connection error: {str(e)}")
        return False

if __name__ == "__main__":
    if len(sys.argv) > 1:
        job_id = sys.argv[1]
    else:
        job_id = input("Enter Job ID to check: ").strip()
        
    if job_id:
        download_result(job_id)
