import time
import sys
from config import API_BASE_URL, get_headers

# Import functions from other scripts to reuse logic
# Note: In a real package structure this would be cleaner, but this works for flat examples
submit_job_module = __import__('2_submit_job')
status_module = __import__('3_check_status')
download_module = __import__('4_download_result')

def run_pipeline():
    print("🚀 Starting End-to-End API Test Pipeline")
    print("=========================================")

    # 1. Submit Job
    print("\n--- Step 1: Submitting Job ---")
    job_id = submit_job_module.submit_job()
    
    if not job_id:
        print("❌ Pipeline stopped due to submission failure.")
        return

    # 2. Poll for Completion
    print(f"\n--- Step 2: Polling Status (Job: {job_id}) ---")
    max_retries = 30  # Wait up to 60 seconds
    status = "PENDING"
    
    for _ in range(max_retries):
        status = status_module.check_status(job_id)
        
        if status == 'completed':
            break
        elif status == 'failed':
            print("❌ Job processing failed.")
            return
            
        time.sleep(2) # Wait 2 seconds between checks
    
    if status != 'completed':
        print("⚠️  Timed out waiting for completion.")
        return

    # 3. Download Result
    print("\n--- Step 3: Downloading Result ---")
    download_module.download_result(job_id)
    
    print("\n=========================================")
    print("✅ Pipeline Completed Successfully!")

if __name__ == "__main__":
    run_pipeline()
