# GCRIPT Python API Client Examples

This directory contains simple Python scripts to demonstrate how to interact with the GCRIPT API programmatically.

## Prerequisites

1.  **Python 3.x**: Ensure you have Python installed.
2.  **Requests Library**: Install the required Python package:
    ```bash
    pip install requests
    ```
3.  **API Key**:
    *   Log in to the GCRIPT Web UI.
    *   Navigate to **Settings > API Keys**.
    *   Generate a new API Key and copy it.

## Configuration

1.  Open `config.py` in a text editor.
2.  Replace `'YOUR_API_KEY_HERE'` with your actual API Key.
3.  Adjust `API_BASE_URL` if your server is running on a different host or port (default is `http://127.0.0.1:5000`).

## Running the Examples

Run the scripts in order to test different functionalities:

1.  **Check Connection**:
    ```bash
    python 1_check_health.py
    ```
2.  **Submit a Job**:
    ```bash
    python 2_submit_job.py
    ```
3.  **Check Job Status**:
    ```bash
    python 3_check_status.py
    ```
4.  **Download Result**:
    ```bash
    python 4_download_result.py
    ```
5.  **Run Full Workflow**:
    ```bash
    python 5_end_to_end.py
    ```
6.  **Advanced: Analyze and Skip Sections**:
    ```bash
    python 6_analyze_and_submit.py
    ```
